#ifndef ANDROID_AUTO_PROJECTION_PROTOCOL_IWIFI_PROJECTION_CALLBACKS_H
#define ANDROID_AUTO_PROJECTION_PROTOCOL_IWIFI_PROJECTION_CALLBACKS_H

#include "common.h"

struct CarWifiCredentialsStruct {
    std::string wifiSsid; /** SSID of car wifi */
    std::string wifiPassword; /** password of car wifi */
    int32_t wifiSecurityMode; /** encryption type of car wifi */
    std::vector<int> supportedWifiChannels; /** all wifi channels supported */
};

class IWifiProjectionCallbacks {
 public:
    virtual ~IWifiProjectionCallbacks() { }

    virtual void onWifiCredentialsRequest(
            CarWifiCredentialsStruct* wifiCreds) = 0;
};

#endif  // ANDROID_AUTO_PROJECTION_PROTOCOL_IWIFI_PROJECTION_CALLBACKS_H
